<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

use Drupal\Core\Entity\EntityStorageInterface;

/**
 * Interface OptionsGeneratorInterface
 *  Defines a utility for generating value:label arrays for entities, suitable
 *  for use as a FAPI #options argument.
 *
 * @package Drupal\dx_toolkit
 */
interface OptionsGeneratorInterface
{

  /**
   * Returns an array of labels, keyed by their respective IDs, generated from
   * all entities that are managed by the provided entity storage handler.
   *
   * @param EntityStorageInterface $entity_storage
   *  Instance of an entity storage handler.
   *
   * @return array
   */
  public static function entitiesAsOptions(
    EntityStorageInterface $entity_storage
  ): array;

  /**
   * Returns an array of labels, keyed by their respective entity IDs, generated
   * from an array containing objects that implement EntityInterface. Non-entity
   * array items will be ignored.
   *
   * @param array $entities
   *  An array containing values of any type. Only those values that are
   *  instances or inheritors of EntityInterface will be included in the
   *  resultant options array.
   *
   * @return array
   */
  public static function optionsFromEntities(array $entities): array;

}
