<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

/**
 * Class PluginBase
 *  Provides a base class to use for standardizing the generation of new
 *  annotation plugin types.
 *
 * @package Drupal\dx_toolkit\Plugin
 */
abstract class PluginBase extends \Drupal\Component\Plugin\PluginBase
  implements PluginBaseInterface
{

  /**
   * @inheritDoc
   */
  public function label(): string {
    return $this->pluginDefinition['label'];
  }

  /**
   * @inheritDoc
   */
  public function pluginDescription(): string {
    return $this->pluginDefinition['description'];
  }

}
