<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface PluginBaseInterface
 *  Defines an interface to use for uniformly interacting with all annotation
 *  plugin types.
 */
interface PluginBaseInterface extends PluginInspectionInterface
{

  /**
   * Returns the label used to identify this plugin type.
   *
   * @return string
   */
  public function label(): string;

  /**
   * Returns the description for this plugin type.
   *
   * @return string
   */
  public function pluginDescription(): string;

}
