<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\dx_toolkit\OptionsGenerator;
use Drupal\dx_toolkit\ServiceInstanceTrait;

/**
 * Class PluginManager
 *  Provides a base class for generating new annotation plugin type managers.
 *
 * @package Drupal\dx_toolkit\Plugin
 */
abstract class PluginManager extends DefaultPluginManager
  implements PluginManagerInterface
{
  use ServiceInstanceTrait;

  /**
   * @inheritDoc
   */
  public function createInstances(array $plugin_ids = NULL): array {
    return array_map(
      fn ($plugin_id) => $this->createInstance($plugin_id),
      $plugin_ids ?? array_keys( $this->getDefinitions() )
    );
  }

  /**
   * @inheritDoc
   */
  public function getPluginDerivatives(string $base_plugin_id): array {
    return array_filter(
      $this->getDefinitions(),
      fn ($definition) => $definition['id'] === $base_plugin_id
    ) ?? [];
  }

  /**
   * @inheritDoc
   */
  public function createDerivativeInstances(string $base_plugin_id): array {
    $plugin_ids = array_keys( $this->getPluginDerivatives($base_plugin_id) );
    return $this->createInstances($plugin_ids);
  }

  /**
   * @inheritDoc
   */
  public function optionLabels(): array {
    return array_map(
      fn (array $definition) => $definition[ static::labelKey() ],
      $this->getDefinitions()
    );
  }

  /**
   * Returns the array definition key to use for returning this plugin type's
   * label. This allows for different plugin types to use different keys
   * (e.g., 'title' vs 'label').
   *
   * @return string
   */
  protected function labelKey(): string {
    return 'label';
  }

}
