<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\dx_toolkit\ServiceInstanceInterface;

/**
 * Interface PluginManager
 *  Defines an object to use for uniformly interacting with all annotation
 *  plugin type managers.
 */
interface PluginManagerInterface
  extends \Drupal\Component\Plugin\PluginManagerInterface,
  ServiceInstanceInterface
{

  /**
   * Returns an array of all plugin instances, keyed by plugin ID, for each
   * valid plugin ID in the provided array of plugin IDs. If an array of plugin
   * IDs is provided, invalid plugin IDs will be ignored. If no argument is
   * provided, all existing plugin IDs for this plugin type will be instantiated
   * and returned.
   *
   * @param array|NULL $plugin_ids
   *
   * @return array
   * @throws PluginException
   */
  public function createInstances(array $plugin_ids = NULL): array;

  /**
   * Returns an array of all plugin derivatives for the given base plugin ID.
   *
   * @param string $base_plugin_id
   *  The base plugin ID for which to return all derivative definitions.
   *
   * @return array
   *  An array of all plugin derivatives for the given base plugin ID.
   */
  public function getPluginDerivatives(string $base_plugin_id): array;

  /**
   * Returns an array of plugin instances for all derivatives of the provided
   * base plugin ID.
   *
   * @param string $base_plugin_id
   *  The base plugin ID for which to return all plugin instances.
   *
   * @return array
   *  An array of plugin instances for all derivatives of the provided
   *  base plugin ID.
   *
   * @throws PluginException
   */
  public function createDerivativeInstances(string $base_plugin_id): array;

  /**
   * Returns an array of plugin labels, keyed by their respective plugin IDs.
   *
   * @return string[]
   *  An array of plugin labels, keyed by their respective plugin IDs.
   */
  public function optionLabels(): array;

}
