<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

/**
 * Interface PluginManagerPropertyQueryInterface
 *  Provides an interface for plugin managers to offer the capability to return
 *  array definitions that match a given set of property values.
 *
 *  @see \Drupal\dx_toolkit\Plugin\PluginManagerPropertyQueryTrait
 */
interface PluginManagerPropertyQueryInterface
{

  /**
   * Returns definitions whose property values match those provided in the
   * property values array, where each key/value pair is a property and its
   * respective value to match.
   *
   * This functionality is similar to ::loadByProperties(), but for plugin
   * definitions within a plugin manager.
   *
   * @param array $property_values
   *
   * @return array
   */
  public function findByProperties(array $property_values): array;

}
