<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

/**
 * Trait ServiceInstanceTrait
 *  Defines a trait that is capable of satisfying the interface requirements of
 *  Drupal\dx_toolkit\ServiceInstanceInterface.
 *
 * @package Drupal\dx_toolkit
 */
trait ServiceInstanceTrait
{

  /**
   * @inheritDoc
   */
  abstract public static function getServiceName(): string;

  /**
   * @inheritDoc
   */
  public static function getService(): static {
    return \Drupal::service( static::getServiceName() );
  }
}
