<?php

declare(strict_types=1);

namespace Drupal\Tests\dx_toolkit\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests the EntityGenerator plugin system.
 *
 * @group dx_toolkit
 */
class EntityGeneratorTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['dx_toolkit', 'system'];

  /**
   * The entity generator manager.
   *
   * @var \Drupal\dx_toolkit\Plugin\EntityGeneratorManager
   */
  protected $entityGeneratorManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installConfig(['system']);
    $this->entityGeneratorManager = $this->container->get(
      'plugin.manager.entity_generator'
    );
  }

  /**
   * Tests that EntityGenerator manager is available.
   */
  public function testEntityGeneratorManagerExists(): void {
    $this->assertNotNull($this->entityGeneratorManager);
    $this->assertInstanceOf(
      'Drupal\dx_toolkit\Plugin\EntityGeneratorManager',
      $this->entityGeneratorManager
    );
  }

  /**
   * Tests that plugin definitions are discovered.
   */
  public function testPluginDefinitionsDiscovered(): void {
    $definitions = $this->entityGeneratorManager->getDefinitions();
    $this->assertIsArray($definitions);
  }

  /**
   * Tests that derivative instances can be loaded.
   */
  public function testDerivativeInstancesCanBeLoaded(): void {
    $definitions = $this->entityGeneratorManager->getDefinitions();

    if (!empty($definitions)) {
      foreach ($definitions as $pluginId => $definition) {
        $instance = $this->entityGeneratorManager->createInstance(
          $pluginId
        );
        $this->assertNotNull($instance);
        $this->assertInstanceOf(
          'Drupal\dx_toolkit\Plugin\EntityGeneratorInterface',
          $instance
        );
      }
    }
    else {
      $this->markTestSkipped('No EntityGenerator plugins available.');
    }
  }

}
