<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit_demo;

/**
 * Interface for content auditing service.
 */
interface ContentAuditorInterface
{

  /**
   * Returns site-wide content statistics.
   *
   * @return array
   *   Statistics including:
   *   - site_name: The site name
   *   - node_count: Total nodes
   *   - term_count: Total taxonomy terms
   *   - user_count: Total users
   *   - total_content: Sum of all content
   */
  public function auditSite(): array;

  /**
   * Returns detailed audit for specific entity type.
   *
   * @param string $entity_type_id
   *   The entity type ID (node, taxonomy_term, or user).
   *
   * @return array
   *   Audit data including:
   *   - entity_type: The entity type ID
   *   - total_count: Total entities
   *   - entities: Sample of up to 10 entities with id, label, bundle
   */
  public function auditByType(string $entity_type_id): array;

}
