<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Annotation;

use Drupal\dx_toolkit\Plugin\EntityGenerator\Derivative\EntityTypeSourceEntityDeriver;

/**
 * Class EntityGeneratorBase
 *  Provides an annotation definition for the EntityGeneratorBase plugin type.
 *
 * @package Drupal\dx_toolkit\Annotation
 *
 * @Annotation
 */
class EntityGenerator extends PluginBase
{

  /**
   * Specifies the name of the target configuration file, less the extension,
   * to use as the base configuration for generating new entities.
   *
   * @var string
   */
  public string $configName;

  /**
   * The folder path that contains the target configuration file, relative
   * to the source module's root folder.
   *
   * @var string
   */
  public string $configPath = 'config/prototype';

  /**
   * The name of the module that provides the target configuration data file.
   *
   * @var string
   */
  public string $sourceModule;

  /**
   * The target entity type ID for this plugin. The target entity type ID
   * specifies the type of entity to be generated from the source configuration.
   *
   * @var string
   */
  public string $targetEntityTypeId;

  /**
   * The entity type ID for which to generate a target entity reference.
   *
   * The generator will iterate through all defined bundles for this entity
   * type and generate a target entity configured per this plugin's
   * merged configuration.
   *
   * @var string
   */
  public string $sourceEntityTypeId;

  /**
   * Returns the bundle machine name that will be assigned when generating a new
   * bundle of the target entity type.
   *
   * @var string
   */
  public string $bundleName;

  /**
   * Assign the default deriver to use for plugin instances.
   *
   * @var string
   */
  public string $deriver = EntityTypeSourceEntityDeriver::class;

}
