<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a ServiceInjector annotation object.
 *
 * Plugin namespace: Plugin\ServiceInjector
 *
 * @Annotation
 */
class ServiceInjector extends Plugin
{

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The human-readable name of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The description of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The factory service ID.
   *
   * @var string
   */
  public string $factoryService;

  /**
   * The factory method name.
   *
   * @var string
   */
  public string $factoryMethod;

  /**
   * The factory method arguments.
   *
   * @var array
   */
  public array $factoryArguments = [];

  /**
   * The service class.
   *
   * @var string
   */
  public string $serviceClass;

  /**
   * The service ID prefix.
   *
   * @var string
   */
  public string $servicePrefix = 'service_injector';

  /**
   * The service ID suffix.
   *
   * @var string
   */
  public string $serviceSuffix = '';

  /**
   * The deriver class.
   *
   * @var string
   */
  public string $deriver = '';

}

