<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

/**
 * Trait AsArrayTrait
 *  Provides a trait for ensuring that a value will always be evaluated as an
 *  array.
 *
 * @package Drupal\dx_toolkit
 */
trait AsArrayTrait
{

  /**
   * Returns the original value unchanged if it is already an array, or
   * returns the original value wrapped in an array.
   * If the value is empty, an empty array is returned.
   *
   * @param $value
   *  The value to evaluate as an array.
   *
   * @return array
   */
  protected static function asArray($value): array {
    if (empty($value)) {
      return [];
    }
    return is_array($value) ? $value : [$value];
  }

}
