<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

use Drupal\Core\Extension\Extension;

/**
 * Interface ExtensionInterface
 *  Defines an object that provides extension-oriented properties and
 *  extension-scope functionality.
 */
interface ExtensionInterface
{

  /**
   * Returns the name of the currently implementing module.
   *
   * @return string
   */
  public static function name(): string;

  /**
   * Returns the label to display for this module.
   *
   * @return string
   */
  public static function label(): string;

  /**
   * Returns a reference to the Extension object that represents this module.
   *
   * @return Extension
   */
  public static function module(): Extension;

  /**
   * Return this extension's relative path.
   *
   * The extension's relative path is the path fragment that acts as the
   * relative file path, and is typically the path following the web root.
   *
   * @see ::root()
   *
   * @return string
   */
  public static function extensionPath(): string;

  /**
   * Returns the root path to the current Drupal instance.
   *
   * The root path is typically the path fragment found at the beginning of an
   * absolute file path, up to the relative path fragment. Typically, this will
   * be the web root.
   *
   * @see ::extensionPath().
   *
   * @return string
   */
  public static function root(): string;

}
