<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityStorageInterface;

/**
 * Class OptionsGenerator
 *  Implementation of an Options Generator.
 *
 * @package Drupal\dx_toolkit
 */
abstract class OptionsGenerator implements OptionsGeneratorInterface
{

  /**
   * @inheritDoc
   */
  public static function entitiesAsOptions(
    EntityStorageInterface $entity_storage
  ): array {
    return array_map(
      fn (EntityInterface $entity) => $entity->label(),
      $entity_storage->loadMultiple()
    );
  }

  /**
   * @inheritDoc
   */
  public static function optionsFromEntities(array $entities): array {
    $filtered = array_filter(
      $entities,
      fn($entity) => class_implements($entity, EntityInterface::class)
    );
    return array_map(
      fn(EntityInterface $entity) => $entity->label(),
      $filtered
    );
  }

}
