<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin\EntityGenerator\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class EntityTypeSourceEntityDeriver
 *  Deriver for EntityGenerator, capable of generating all necessary plugin
 *  definitions for a given plugin implementation, so long as a valid
 *  sourceEntityTypeId annotation value has been specified for the plugin
 *  implementation.
 *
 * @package Drupal\dx_toolkit\Plugin\EntityGenerator\Derivative
 */
class EntityTypeSourceEntityDeriver extends DeriverBase
  implements ContainerDeriverInterface
{

  /**
   * Internal list of definitions.
   *
   * @var array
   */
  protected array $definitions = [];

  /**
   * @param EntityTypeBundleInfoInterface $entityTypeBundleInfo
   */
  public function __construct(
    protected EntityTypeBundleInfoInterface $entityTypeBundleInfo
  ) {}

  /**
   * @inheritDoc
   */
  public static function create(
    ContainerInterface $container,
    $base_plugin_id
  ): static {
    return new static($container->get('entity_type.bundle.info'));
  }

  /**
   * @inheritDoc
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    $this->definitions = [];
    if (!$source = ($base_plugin_definition['sourceEntityTypeId'] ?? NULL)) {
      return $this->definitions;
    }
    return $this->definitions = array_map(
      fn ($bundle) => [
        ...$base_plugin_definition,
        'bundleName' => $bundle,
      ],
      array_keys( $this->entityTypeBundleInfo->getBundleInfo($source) ),
    );
  }

}
