<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;
use Drupal\feeds\FeedInterface;

/**
 * Interface FeedTypeGeneratorInterface
 *  A specialized EntityGeneratorInterface that provides additional
 *  functionality for generating Feeds when generating companion Feed Types.
 */
interface FeedTypeGeneratorInterface
{

  /**
   * Generates a feed from this object's target Feed type, if none already
   * exist.
   *
   * @param string $source
   *  The source to assign to the generated Feed.
   *
   * @return $this
   */
  public function generateFeed(string $source = ''): static;

  /**
   * Returns all Feeds that are of this object's target Feed type.
   *
   * @return FeedInterface[]
   */
  public function feeds(): array;

  /**
   * Deletes all Feeds that are of this object's target Feed type.
   *
   * @return $this
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function deleteFeeds(): static;

  /**
   * For all Feeds that are of this object's Feed type, the feed will be
   * imported using the existing source, unless a new source is provided, in
   * which case the provided source will be assigned and used.
   *
   * @param string|null $source
   *
   * @return $this
   * @throws \Exception
   */
  public function import(string $source = NULL): static;

}
