<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

/**
 * Trait PluginManagerPropertyQueryTrait
 *  Provides the ability to find plugin definitions by a given set of properties
 *  and values.
 *
 *  This trait is intended to fulfill the contract encapsulated in
 *  Drupal\dx_toolkit\Plugin\PluginManagerPropertyQueryTrait
 */
trait PluginManagerPropertyQueryTrait
{

  /**
   * Requires that an array of definitions is returned.
   *
   * @return array
   * @noinspection PhpMissingReturnTypeInspection
   */
  abstract public function getDefinitions();

  /**
   * @inheritDoc
   */
  public function findByProperties(array $property_values): array {
    // Return definitions that contain all of the properties and respective
    // property values found in the provided array.
    return array_filter(
      $this->getDefinitions(),
      fn (array $definition) =>
        array_intersect_assoc($property_values, $definition)
          === $property_values
    );
  }

}
