<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin\ServiceInjector;

use Drupal\dx_toolkit\Plugin\ServiceInjectorBase;

/**
 * ServiceInjector plugin for entity storage handlers.
 *
 * Provides entity storage handlers via @entity_type.manager::getStorage
 * for all entity types. Generates services like:
 * - service_injector.node.storage
 * - service_injector.taxonomy_term.storage
 * - service_injector.user.storage
 *
 * @ServiceInjector(
 *   id = "entity_storage",
 *   label = @Translation("Entity Storage"),
 *   description = @Translation(
 *     "Provides entity storage handlers via factory injection."
 *   ),
 *   factoryService = "@entity_type.manager",
 *   factoryMethod = "getStorage",
 *   serviceClass = "Drupal\Core\Entity\EntityStorageInterface",
 *   servicePrefix = "service_injector",
 *   serviceSuffix = "storage",
 *   deriver = "Drupal\dx_toolkit\Plugin\ServiceInjector\Derivative\EntityStorageDeriver"
 * )
 *
 * @package Drupal\dx_toolkit\Plugin\ServiceInjector
 */
class EntityStorage extends ServiceInjectorBase {}

