<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for ServiceInjector plugins.
 *
 * @package Drupal\dx_toolkit\Plugin
 */
abstract class ServiceInjectorBase extends PluginBase
  implements ServiceInjectorInterface, ContainerFactoryPluginInterface
{

  /**
   * Constructs a ServiceInjectorBase object.
   *
   * @param array $configuration
   *   Plugin configuration.
   * @param string $plugin_id
   *   The plugin ID.
   * @param mixed $plugin_definition
   *   The plugin definition.
   */
  public function __construct(
    $configuration,
    $plugin_id,
    $plugin_definition
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * @inheritDoc
   */
  public static function create(
    ContainerInterface $container,
    array $configuration,
    $plugin_id,
    $plugin_definition
  ): static {
    return new static($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * @inheritDoc
   */
  public function serviceId(): string {
    return implode('.', [
      $this->servicePrefix(),
      ...$this->factoryArguments(),
      $this->serviceSuffix(),
    ]);
  }

  /**
   * @inheritDoc
   */
  public function factoryService(): string {
    return $this->pluginDefinition['factoryService'] ?? '';
  }

  /**
   * @inheritDoc
   */
  public function factoryMethod(): string {
    return $this->pluginDefinition['factoryMethod'] ?? '';
  }

  /**
   * @inheritDoc
   */
  public function factoryArguments(): array {
    return $this->pluginDefinition['factoryArguments'] ?? [];
  }

  /**
   * @inheritDoc
   */
  public function serviceClass(): string {
    return $this->pluginDefinition['serviceClass'] ?? '';
  }

  /**
   * @inheritDoc
   */
  public function servicePrefix(): string {
    return $this->pluginDefinition['servicePrefix'] ?? 'service_injector';
  }

  /**
   * @inheritDoc
   */
  public function serviceSuffix(): string {
    return $this->pluginDefinition['serviceSuffix'] ?? $this->getPluginId();
  }

//  /**
//   * @inheritDoc
//   */
//  public function registerService(ContainerBuilder $container): static {
//    $container
//      ->register(
//        $this->serviceId(),
//        $this->serviceClass(),
//      )
//      ->setFactory([
//        $this->factoryService(),
//        $this->factoryMethod(),
//      ])
//      ->setArguments($this->factoryArguments());
//    return $this;
//  }
  /**
   * @inheritDoc
   */
  public function getServiceDefinition(): array {
    return [
      $this->serviceId() => [
        'class' => $this->serviceClass(),
        'factory' => [
          $this->factoryService(),
          $this->factoryMethod(),
        ],
        'arguments' => $this->factoryArguments(),
      ],
    ];
  }

}

