<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

use Drupal\Core\DependencyInjection\ContainerBuilder;

/**
 * Interface for ServiceInjector plugins.
 *
 * ServiceInjector plugins describe services that use the factory pattern
 * for dependency injection.
 *
 * @package Drupal\dx_toolkit\Plugin
 */
interface ServiceInjectorInterface extends PluginBaseInterface
{

  /**
   * Returns the full service ID for this injector.
   *
   * @return string
   *   The service ID (e.g., 'service_injector.node.storage').
   */
  public function serviceId(): string;

  /**
   * Returns the factory service ID.
   *
   * @return string
   *   The factory service ID (e.g., '@entity_type.manager').
   */
  public function factoryService(): string;

  /**
   * Returns the factory method name.
   *
   * @return string
   *   The method name (e.g., 'getStorage').
   */
  public function factoryMethod(): string;

  /**
   * Returns the arguments to pass to the factory method.
   *
   * @return array
   *   Array of arguments for the factory method.
   */
  public function factoryArguments(): array;

  /**
   * Returns the service class or interface name.
   *
   * @return string
   *   Fully qualified class or interface name.
   */
  public function serviceClass(): string;

  /**
   * Returns the service prefix used for service IDs.
   *
   * @return string
   *   The service prefix (e.g., 'service_injector').
   */
  public function servicePrefix(): string;

  /**
   * Returns the service suffix used for service IDs.
   *
   * @return string
   *   The service suffix (e.g., 'storage', 'config').
   */
  public function serviceSuffix(): string;

//  /**
//   * Allows the plugin to register its service definition.
//   *
//   * @param \Drupal\Core\DependencyInjection\ContainerBuilder $container
//   *  The service container builder.
//   *
//   * @return $this
//   */
//  public function registerService(ContainerBuilder $container): static;

  /**
   * Returns the service definition for registering this injected service.
   *
   * @return array
   */
  public function getServiceDefinition(): array;
}

