<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\dx_toolkit\Annotation\ServiceInjector;
use Drupal\dx_toolkit\Extension;
use Traversable;

/**
 * Manages ServiceInjector plugins.
 *
 * @package Drupal\dx_toolkit\Plugin
 */
class ServiceInjectorManager extends PluginManager
  implements PluginManagerInterface
{

  /**
   * Constructs a ServiceInjectorManager object.
   *
   * @param \Traversable $namespaces
   *   An object with module namespaces.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   Module handler.
   */
  public function __construct(
    Traversable $namespaces,
    CacheBackendInterface $cache_backend,
    ModuleHandlerInterface $module_handler
  ) {
    parent::__construct(
      'Plugin/ServiceInjector',
      $namespaces,
      $module_handler,
      ServiceInjectorInterface::class,
      ServiceInjector::class
    );
    $this->alterInfo('service_injector_info');
    $this->setCacheBackend(
      $cache_backend,
      'service_injector_plugins'
    );
  }

  /**
   * @inheritDoc
   */
  public static function getServiceName(): string {
    return 'plugin.manager.service_injector';
  }

}

