<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit;

/**
 * Interface ServiceInstanceInterface
 *  Defines an interface for a service class to return an instance of itself
 *  from the DIC.
 *
 * @package Drupal\dx_toolkit
 */
interface ServiceInstanceInterface
{

  /**
   * Return the name of the implementing class's service definition.
   *
   * @return string
   */
  public static function getServiceName(): string;

  /**
   * Returns an instance of this class as a service.
   *
   * @return $this
   */
  public static function getService(): static;
}
