<?php

declare(strict_types=1);

namespace Drupal\dx_toolkit\State;

use Drupal\dx_toolkit\StateBase;

/**
 * Class PreInstallState
 *  StateBase handler for tracking the module pre-install flag. This is useful
 *  for toggling behavior that would otherwise produce errors during the
 *  pre-installation phase of the module installation process.
 *
 * @see dx_toolkit_module_preinstall()
 * @see dx_toolkit_install()
 *
 * @package Drupal\dx_toolkit
 */
class PreInstallState extends StateBase
{

  /**
   * @inheritDoc
   */
  public function name(): string {
    return 'preInstall';
  }

  /**
   * @inheritDoc
   */
  protected function context(): string {
    return 'module';
  }

}
