<?php

declare(strict_types=1);

namespace Drupal\Tests\dx_toolkit\Kernel;

use Drupal\dx_toolkit\State\PreInstallState;
use Drupal\KernelTests\KernelTestBase;

/**
 * Tests for PreInstallState integration.
 *
 * @group dx_toolkit
 * @coversDefaultClass \Drupal\dx_toolkit\State\PreInstallState
 */
class PreInstallStateTest extends KernelTestBase {

  /**
   * Tests PreInstallState with setState() injection.
   *
   * @covers ::name
   * @covers ::context
   */
  public function testPreInstallStateWithSetState(): void {
    $state_service = $this->container->get('state');
    $pre_install = new PreInstallState();
    $pre_install->setState($state_service);

    $pre_install->set(TRUE);
    $this->assertTrue($pre_install->get());

    $pre_install->set(FALSE);
    $this->assertFalse($pre_install->get());

    $pre_install->delete();
    $this->assertNull($pre_install->get());
  }

  /**
   * Tests that PreInstallState uses correct key.
   */
  public function testPreInstallStateKey(): void {
    $state_service = $this->container->get('state');
    $pre_install = new PreInstallState();
    $pre_install->setState($state_service);

    $pre_install->set(TRUE);

    $raw_value = $state_service->get('module:preInstall');
    $this->assertTrue($raw_value);
  }

  /**
   * Tests PreInstallState uses lazy initialization without setState().
   */
  public function testPreInstallStateWithoutSetStateUsesLazyInit(): void {
    $pre_install = new PreInstallState();

    $pre_install->set(TRUE);
    $this->assertTrue($pre_install->get());

    $pre_install->delete();
  }

}
