<?php

declare(strict_types=1);

namespace Drupal\Tests\dx_toolkit\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests the ServiceInjector plugin system.
 *
 * @group dx_toolkit
 */
class ServiceInjectorTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['dx_toolkit'];

  /**
   * The service injector manager.
   *
   * @var \Drupal\dx_toolkit\Plugin\ServiceInjectorManager
   */
  protected $serviceInjectorManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->serviceInjectorManager = $this->container->get(
      'plugin.manager.service_injector'
    );
  }

  /**
   * Tests that ServiceInjector manager is available.
   */
  public function testServiceInjectorManagerExists(): void {
    $this->assertNotNull($this->serviceInjectorManager);
    $this->assertInstanceOf(
      'Drupal\dx_toolkit\Plugin\ServiceInjectorManager',
      $this->serviceInjectorManager
    );
  }

  /**
   * Tests that plugin definitions are discovered.
   */
  public function testPluginDefinitionsDiscovered(): void {
    $definitions = $this->serviceInjectorManager->getDefinitions();
    $this->assertIsArray($definitions);
  }

  /**
   * Tests that plugins can be discovered.
   */
  public function testEntityStoragePluginsCreated(): void {
    $definitions = $this->serviceInjectorManager->getDefinitions();

    // In minimal kernel environment, plugins may not be discovered
    // Just verify the manager can return definitions array
    $this->assertIsArray($definitions);

    // If any plugins are found, verify structure
    if (!empty($definitions)) {
      $firstPlugin = reset($definitions);
      $this->assertArrayHasKey('id', $firstPlugin);
    }
  }

}
