<?php

namespace Drupal\dxpr_cms_layouts\Plugin\Layout;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Layout\LayoutDefault;
use Drupal\Core\Plugin\PluginFormInterface;

class DxprOneColumn extends LayoutDefault implements PluginFormInterface {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'section_classes' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);
    $configuration = $this->getConfiguration();

    $form['section_classes'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Section Classes'),
      '#default_value' => $configuration['section_classes'],
      '#description' => $this->t('Additional CSS classes for the section wrapper. Separate multiple classes with spaces.'),
      '#maxlength' => 255,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::validateConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
    $this->configuration['section_classes'] = $form_state->getValue('section_classes');
  }

  /**
   * {@inheritdoc}
   */
  public function build(array $regions) {
    $build = parent::build($regions);
    $build['#attributes']['class'][] = 'dxpr-one-column-layout';
    $build['#attributes']['class'][] = 'container-fluid';
    
    if (!empty($this->configuration['section_classes'])) {
      $custom_classes = explode(' ', $this->configuration['section_classes']);
      foreach ($custom_classes as $class) {
        if (!empty(trim($class))) {
          $build['#attributes']['class'][] = trim($class);
        }
      }
    }
    
    return $build;
  }

}