import _rgb2hsv from './rgb2hsv';
import _hsv2rgb from './hsv2rgb';
export interface ReinventedColorWheelOptions {
    readonly appendTo: HTMLElement | DocumentFragment;
    readonly hsv?: Readonly<[number, number, number]>;
    readonly hsl?: Readonly<[number, number, number]>;
    readonly rgb?: Readonly<[number, number, number]>;
    readonly hex?: string;
    readonly wheelDiameter?: number;
    readonly wheelThickness?: number;
    readonly handleDiameter?: number;
    readonly wheelReflectsSaturation?: boolean;
    readonly onChange?: (color: ReinventedColorWheel) => any;
}
export default class ReinventedColorWheel {
    private options;
    static default: typeof ReinventedColorWheel;
    static defaultOptions: {
        hsv: [number, number, number];
        hsl: [number, number, number];
        wheelDiameter: number;
        wheelThickness: number;
        handleDiameter: number;
        wheelReflectsSaturation: boolean;
        onChange: (color: ReinventedColorWheel) => any;
    };
    static hsv2hsl: (hsv: ArrayLike<number>) => [number, number, number];
    static hsl2hsv: (hsl: ArrayLike<number>) => [number, number, number];
    static hsv2rgb: typeof _hsv2rgb;
    static rgb2hsv: typeof _rgb2hsv;
    static rgb2hex: (rgb: ArrayLike<number>) => string;
    static hex2rgb: (hex: string) => [number, number, number];
    wheelDiameter: number;
    wheelThickness: number;
    handleDiameter: number;
    onChange: (color: ReinventedColorWheel) => any;
    wheelReflectsSaturation: boolean;
    readonly rootElement: HTMLDivElement;
    readonly hueWheelElement: HTMLCanvasElement;
    readonly hueWheelContext: CanvasRenderingContext2D;
    readonly hueHandleElement: HTMLDivElement;
    readonly svSpaceElement: HTMLCanvasElement;
    readonly svSpaceContext: CanvasRenderingContext2D;
    readonly svHandleElement: HTMLDivElement;
    private _redrawHueWheelRequested;
    private _inverseTransform;
    private _center;
    private _hsv;
    private _hsl;
    private _rgb;
    private _hex;
    get hsv(): Readonly<[number, number, number]>;
    get hsl(): Readonly<[number, number, number]>;
    get rgb(): Readonly<[number, number, number]>;
    get hex(): string;
    set hsv(value: Readonly<[number, number, number]>);
    set hsl(value: Readonly<[number, number, number]>);
    set rgb(value: Readonly<[number, number, number]>);
    set hex(value: string);
    /** @deprecated */ setHSV(): void;
    /** @deprecated */ setHSL(): void;
    constructor(options: ReinventedColorWheelOptions);
    redraw(): void;
    private _setHSV;
    private _redrawHueWheel;
    private _redrawSvSpace;
    private _updateSvBackground;
    private _redrawHueHandle;
    private _redrawSvHandle;
}
