<?php

namespace Drupal\dynamic_image_generator;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;

/**
 * Provides an interface for defining Image Template entities.
 *
 * @ingroup dynamic_image_generator
 */
interface ImageTemplateInterface extends ContentEntityInterface, EntityChangedInterface {

  /**
   * Gets the Image Template title.
   *
   * @return string
   *   Title of the Image Template.
   */
  public function getTitle();

  /**
   * Sets the Image Template title.
   *
   * @param string $title
   *   The Image Template title.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setTitle($title);

  /**
   * Gets the content type.
   *
   * @return string
   *   The content type machine name.
   */
  public function getContentType();

  /**
   * Sets the content type.
   *
   * @param string $content_type
   *   The content type machine name.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setContentType($content_type);

  /**
   * Gets the target field.
   *
   * @return string
   *   The target field name.
   */
  public function getTargetField();

  /**
   * Sets the target field.
   *
   * @param string $target_field
   *   The target field name.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setTargetField($target_field);

  /**
   * Gets the HTML template.
   *
   * @return string
   *   HTML template of the Image Template.
   */
  public function getHTML();

  /**
   * Sets the HTML template.
   *
   * @param string $html
   *   The HTML template.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setHTML($html);

  /**
   * Gets the CSS template.
   *
   * @return string
   *   CSS template of the Image Template.
   */
  public function getCSS();

  /**
   * Sets the CSS template.
   *
   * @param string $css
   *   The CSS template.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setCSS($css);

  /**
   * Gets the background images.
   *
   * @return \Drupal\file\FileInterface[]
   *   Array of background image files.
   */
  public function getBackgroundImages();

  /**
   * Gets the Image Template creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Image Template.
   */
  public function getCreatedTime();

  /**
   * Sets the Image Template creation timestamp.
   *
   * @param int $timestamp
   *   The Image Template creation timestamp.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Image Template active status indicator.
   *
   * @return bool
   *   TRUE if the Image Template is active, FALSE otherwise.
   */
  public function isActive();

  /**
   * Sets the active status of an Image Template.
   *
   * @param bool $active
   *   TRUE to set this Image Template to active, FALSE to set it to inactive.
   *
   * @return \Drupal\dynamic_image_generator\ImageTemplateInterface
   *   The called Image Template entity.
   */
  public function setActive($active);
}