<?php

namespace Drupal\image_creating_engine\Plugin\ImageGenerator;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\dynamic_image_generator\Plugin\ImageGeneratorPluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Built-in image generator plugin.
 *
 * @ImageGenerator(
 *   id = "inbuilt",
 *   label = @Translation("Built-in Image Engine"),
 *   description = @Translation("Generates images using built-in PHP capabilities.")
 * )
 */
class InbuiltImageGeneratorPlugin extends ImageGeneratorPluginBase implements ContainerFactoryPluginInterface {

  /**
   * The inbuilt image generator service.
   *
   * @var \Drupal\image_creating_engine\Service\InbuiltImageGenerator
   */
  protected $imageGenerator;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static($configuration, $plugin_id, $plugin_definition);
    $instance->imageGenerator = $container->get('image_creating_engine.generator');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function generateImage($html, $css, array $options = []) {
    return $this->imageGenerator->generateImage($html, $css, $options);
  }

}
