(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.dynamicImageGenerator = {
    attach: function (context, settings) {
      // Add styling to the dynamic image generator section
      once('dynamic-image-generator', '#edit-dynamic-image-generator', context).forEach(function(element) {
        $(element).addClass('dynamic-image-generator-section');
        
        // Style preview buttons
        $(element).find('input[id*="preview-template"]').addClass('button--preview');
        
        // Handle preview responses
        $(element).on('ajaxComplete', function(event, xhr, ajaxSettings) {
          if (ajaxSettings.url && ajaxSettings.url.indexOf('preview') !== -1) {
            // Scroll to preview if needed
            var $preview = $(element).find('.dynamic-image-preview').last();
            if ($preview.length) {
              $preview.get(0).scrollIntoView({ behavior: 'smooth', block: 'nearest' });
            }
          }
        });
      });
      
      // Handle preview button styling
      once('preview-buttons', 'input[id*="preview-template"]', context).forEach(function(button) {
        $(button).addClass('button--preview');
      });
      
      // Override the AJAX callback to send current form data
      once('preview-ajax-override', '#edit-dynamic-image-generator input[id*="preview-template"]', context).forEach(function(button) {
        $(button).on('mousedown', function(e) {
          // Capture current form values before AJAX call
          var $form = $(this).closest('form');
          var formData = {};
          
          // Get title field value
          var titleField = $form.find('input[name="title[0][value]"]');
          if (titleField.length) {
            formData.title = titleField.val();
          }
          
          // Get all field values that start with 'field_'
          $form.find('input, textarea, select').each(function() {
            var name = $(this).attr('name');
            if (name && name.indexOf('field_') === 0) {
              var value = $(this).val();
              if (value) {
                // Extract field name (remove array notation)
                var fieldName = name.split('[')[0];
                formData[fieldName] = value;
              }
            }
          });
          
          // Store form data for the AJAX callback
          $(this).data('current-form-data', formData);
        });
      });
    }
  };

  // Override the AJAX beforeSend to include current form data
  $(document).ajaxSend(function(event, jqXHR, ajaxSettings) {
    if (ajaxSettings.url && ajaxSettings.url.indexOf('preview') !== -1) {
      // Find the triggering element
      var $trigger = $('.ajax-progress').closest('.form-item').find('input[id*="preview-template"]');
      if ($trigger.length) {
        var formData = $trigger.data('current-form-data');
        if (formData) {
          // Modify the request to include current form data
          var originalData = ajaxSettings.data;
          if (typeof originalData === 'string') {
            originalData += '&current_form_data=' + encodeURIComponent(JSON.stringify(formData));
          } else {
            originalData.current_form_data = JSON.stringify(formData);
          }
          ajaxSettings.data = originalData;
        }
      }
    }
  });

})(jQuery, Drupal, once);
