<?php

// File: src/Form/ImageTemplateDeleteForm.php

namespace Drupal\dynamic_image_generator\Form;

use Drupal\Core\Entity\ContentEntityDeleteForm;

/**
 * Provides a form for deleting Image Template entities.
 *
 * @ingroup dynamic_image_generator
 */
class ImageTemplateDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('This action will permanently delete the poster template and cannot be undone. Any generated posters using this template will remain but can no longer be regenerated.');
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete Poster Template');
  }
}