<?php

// File: src/Form/ImageTemplateForm.php

namespace Drupal\dynamic_image_generator\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Image Template edit forms.
 *
 * @ingroup dynamic_image_generator
 */
class ImageTemplateForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);

    // The AJAX functionality is now handled in hook_form_alter
    // This keeps the form clean and follows Drupal best practices
    
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addMessage($this->t('Created the %label Image Template.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        $this->messenger()->addMessage($this->t('Saved the %label Image Template.', [
          '%label' => $entity->label(),
        ]));
    }
    
    $form_state->setRedirect('entity.poster_entity.collection');
  }
}