<?php

// File: src/ImageTemplateListBuilder.php

namespace Drupal\dynamic_image_generator;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Poster entities.
 *
 * @ingroup dynamic_image_generator
 */
class ImageTemplateListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Poster ID');
    $header['title'] = $this->t('Title');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\dynamic_image_generator\Entity\ImageTemplate $entity */
    $row['id'] = $entity->id();
    $row['title'] = Link::createFromRoute(
      $entity->label(),
      'entity.poster_entity.edit_form',
      ['poster_entity' => $entity->id()]
    );
    return $row + parent::buildRow($entity);
  }

}