<?php

/**
 * @file
 * Debug helper functions for image creation.
 */

/**
 * Log debugging information about a variable.
 *
 * @param mixed $var
 *   The variable to debug.
 * @param string $title
 *   A title for the debug message.
 */
function image_creating_engine_debug($var, $title = 'Debug') {
  $logger = \Drupal::logger('image_creating_engine');
  
  $type = gettype($var);
  $logger->debug('@title - Type: @type', [
    '@title' => $title,
    '@type' => $type,
  ]);
  
  if ($type === 'array') {
    $logger->debug('@title - Array keys: @keys', [
      '@title' => $title,
      '@keys' => implode(', ', array_keys($var)),
    ]);
    
    // Log first level of array contents
    foreach ($var as $key => $value) {
      $value_type = gettype($value);
      $value_preview = $value_type === 'object' ? get_class($value) : substr(print_r($value, TRUE), 0, 100);
      $logger->debug('@title - @key (@type): @value', [
        '@title' => $title,
        '@key' => $key,
        '@type' => $value_type,
        '@value' => $value_preview,
      ]);
    }
  }
  elseif ($type === 'object') {
    $logger->debug('@title - Object class: @class', [
      '@title' => $title,
      '@class' => get_class($var),
    ]);
  }
  else {
    // For simple types, just log the value
    $value_preview = substr(print_r($var, TRUE), 0, 500);
    $logger->debug('@title - Value: @value', [
      '@title' => $title,
      '@value' => $value_preview,
    ]);
  }
}
