/**
 * @file
 * JavaScript for Image Template form functionality.
 */

(function ($, Drupal) {
  'use strict';

  /**
   * Behavior for Image Template form enhancements.
   */
  Drupal.behaviors.imageTemplateForm = {
    attach: function (context, settings) {
      // Add any additional form enhancements here
      $('#edit-content-type', context).once('image-template-form').each(function () {
        $(this).on('change', function () {
          // Show loading indicator while AJAX processes
          $('#target-field-wrapper').addClass('ajax-loading');
        });
      });

      // Remove loading indicator when AJAX completes
      $(document).ajaxComplete(function () {
        $('#target-field-wrapper').removeClass('ajax-loading');
      });
      
      // Fix for test buttons visibility
      $('#edit-api-provider', context).once('api-provider-buttons').each(function() {
        $(this).on('change', function() {
          var selected = $(this).val();
          
          // Hide all test buttons first
          $('.api-test-container button').hide();
          
          // Show the appropriate button based on selection
          if (selected === 'htmlcsstoimage') {
            $('input[name="test_htmlcsstoimage"]').show();
          } else if (selected === 'inbuilt') {
            $('input[name="test_inbuilt"]').show();
          }
        });
        
        // Trigger change on page load to set initial state
        $(this).trigger('change');
      });
    }
  };

})(jQuery, Drupal);
