<?php

/**
 * @file
 * Contains poster_entity.page.inc.
 *
 * Page callback for Poster entity entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Poster entity templates.
 *
 * Default template: poster_entity.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_poster_entity(array &$variables) {
  // Fetch PosterEntity Entity Object.
  $poster_entity = $variables['elements']['#poster_entity'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}

/**
 * Prepares variables for a custom entity type creation list templates.
 *
 * Default template: poster_entity-content-add-list.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - content: An array of poster-entity-types.
 *
 * @see block_content_add_page()
 */
function template_preprocess_poster_entity_content_add_list(array &$variables) {
  $variables['types'] = [];
  $query = \Drupal::request()->query->all();
  foreach ($variables['content'] as $type) {
    $variables['types'][$type->id()] = [
      'link' => \Drupal::service('link_generator')->generate($type->label(), new \Drupal\Core\Url('entity.poster_entity.add_form', [
        'poster_entity_type' => $type->id()
      ], ['query' => $query])),
      'description' => [
        '#markup' => $type->label(),
      ],
      'title' => $type->label(),
      'localized_options' => [
        'query' => $query,
      ],
    ];
  }
}
