<?php

namespace Drupal\dynamic_image_generator;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Image Template entity.
 *
 * @see \Drupal\dynamic_image_generator\Entity\ImageTemplate.
 */
class ImageTemplateAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\dynamic_image_generator\Entity\ImageTemplateInterface $entity */

    switch ($operation) {

      case 'view':
        if (!$entity->isActive()) {
          return AccessResult::allowedIfHasPermission($account, 'administer poster entity');
        }
        return AccessResult::allowedIfHasPermission($account, 'view poster entity')
          ->orIf(AccessResult::allowedIfHasPermission($account, 'administer poster entity'));

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'administer poster entity');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'administer poster entity');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'administer poster entity');
  }
}