# Dynamic Placeholder Module

A Drupal 10/11 module that provides configurable rotating placeholder text for text input fields, similar to Blinkit's search functionality.

## Features

- Rotating placeholder text that changes every few seconds
- Configurable CSS selector to target any input field
- Customizable placeholder prefix (e.g., "Search ")
- Multiple placeholder items that rotate automatically
- Configurable rotation interval
- Optional randomization of placeholder order
- Pause on focus option (stops rotation when user focuses the input)
- Production-ready and lightweight (no external dependencies)

## Installation

1. **Enable the module:**
   ```bash
   drush en dynamic_placeholder
   ```
   Or via the admin interface: Extend → Dynamic Placeholder

2. **Configure the module:**
   - Navigate to: **Configuration → User Interface → Dynamic Placeholder**
   - Or visit: `/admin/config/user-interface/dynamic-placeholder`

3. **Set up the configuration:**
   - Check "Enable Dynamic Placeholder"
   - Enter the CSS selector for your target input field
   - Set the placeholder prefix (default: "Search " - note the space at the end). Leave empty ("") to use items without a prefix
   - Add placeholder items (one per line)
   - Configure rotation interval (default: 2000ms)
   - Optionally enable "Randomize Order" and "Pause on Focus"

4. **Save the configuration**

## Finding the Correct CSS Selector

The module requires a CSS selector to target the input field. Here are common examples:

### Core Search Block

For Drupal's core search block (like the one with placeholder "Search for services, information, and more"), try these selectors in order:

**Option 1 (Most common):**
```
#edit-keys
```

**Option 2 (If IDs are dynamic or multiple blocks exist):**
```
input[name="keys"]
```

**Option 3 (More specific, targets search block form):**
```
.search-block-form input[name="keys"]
```

**Option 4 (If using Search API autocomplete):**
```
#edit-keywords
```
or
```
input[name="keywords"]
```

**For the Riverside County search block specifically:**
The search input field shown in the header uses the `search_block_form` with field `keys`. Start with:
```
#edit-keys
```
If that doesn't work (due to dynamic IDs), use:
```
input[name="keys"]
```

### Views Exposed Filter Input

For Views exposed filter inputs, use:
```
input[name="search_api_fulltext"]
```

Or more specifically:
```
.views-exposed-form input[type="search"]
```

### Search API Page Input

For Search API pages:
```
input[name="search_api_fulltext"]
```

Or:
```
.search-api-page-form input[type="text"]
```

### Custom Selectors

You can use any valid CSS selector:
- ID selector: `#my-search-input`
- Class selector: `.header-search input[type="search"]`
- Attribute selector: `input[name="search_api_fulltext"]`
- Combined: `.search-wrapper input.form-search`

### How to Find the Selector

1. **Using Browser Developer Tools:**
   - Right-click on the input field
   - Select "Inspect Element"
   - In the Elements/Inspector panel, right-click on the highlighted element
   - Select "Copy → Copy selector" (Chrome/Edge) or use the element's ID/class

2. **Common Patterns:**
   - Look for `id` attribute: `id="edit-keys"` → selector: `#edit-keys`
   - Look for `name` attribute: `name="search_api_fulltext"` → selector: `input[name="search_api_fulltext"]`
   - Look for `class` attribute: `class="form-search"` → selector: `.form-search`

3. **Test the Selector:**
   - Open browser console (F12)
   - Type: `document.querySelector('YOUR_SELECTOR')`
   - If it returns the input element, the selector is correct

## Configuration Examples

### Example 1: Basic Search Box

- **Target Selector:** `#edit-keys`
- **Placeholder Prefix:** `Search `
- **Placeholder Items:**
  ```
  Curd
  Books
  News
  Events
  ```
- **Rotation Interval:** `2000` (2 seconds)
- **Randomize Order:** Unchecked
- **Pause on Focus:** Checked

### Example 2: Search API Fulltext

- **Target Selector:** `input[name="search_api_fulltext"]`
- **Placeholder Prefix:** `Find `
- **Placeholder Items:**
  ```
  Services
  Departments
  Documents
  People
  ```
- **Rotation Interval:** `3000` (3 seconds)
- **Randomize Order:** Checked
- **Pause on Focus:** Checked

## Behavior

- The placeholder rotates automatically at the configured interval
- If the user types in the input, rotation stops (placeholder is not overwritten)
- If "Pause on Focus" is enabled, rotation pauses when the input is focused
- When the input loses focus and is empty, rotation resumes
- If the placeholder items list is empty, the module does nothing safely
- The module uses Drupal's `once()` to ensure each input is only processed once

## Technical Details

- **Drupal Version:** 10.x / 11.x
- **Dependencies:** None (uses core libraries)
- **JavaScript:** Uses Drupal behaviors and `once()` for modern Drupal 10/11 compatibility
- **Configuration:** Uses Drupal Config API
- **Caching:** Properly handles cache tags for configuration changes

## Troubleshooting

### Placeholder Not Rotating

1. **Check if module is enabled:** Verify the checkbox is checked in the configuration form
2. **Verify selector:** Use browser console to test if the selector matches your input
3. **Check placeholder items:** Ensure at least one item is configured
4. **Clear cache:** Run `drush cr` or clear cache via admin interface
5. **Check browser console:** Look for JavaScript errors

### Selector Not Working

- Make sure the selector is unique and matches exactly
- Use browser developer tools to verify the selector
- Try a more specific selector (e.g., add parent class)
- Check if the input exists on the page (may be loaded via AJAX)

### Rotation Too Fast/Slow

- Adjust the "Rotation Interval" setting (minimum: 500ms)
- Values are in milliseconds (1000ms = 1 second)

## Development

### File Structure

```
dynamic_placeholder/
├── dynamic_placeholder.info.yml
├── dynamic_placeholder.libraries.yml
├── dynamic_placeholder.module
├── dynamic_placeholder.routing.yml
├── dynamic_placeholder.links.menu.yml
├── js/
│   └── dynamic-placeholder.js
├── src/
│   └── Form/
│       └── DynamicPlaceholderSettingsForm.php
└── README.md
```

### Code Standards

- Follows Drupal Coding Standards
- Uses Drupal 10/11 best practices
- Proper use of Config API
- Modern JavaScript with `once()` instead of jQuery.once

## License

This module follows the same license as Drupal core (GPL v2+).

