<?php

namespace Drupal\dynamic_reference_selection\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * The dynamic reference selection reacts on plugin manager.
 */
class DynamicReferenceSelectionReactsOnManager extends DefaultPluginManager {

  /**
   * Constructor for DynamicReferenceSelectionReactsOnManager objects.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/DynamicReferenceSelectionReactsOn', $namespaces, $module_handler, 'Drupal\dynamic_reference_selection\Plugin\DynamicReferenceSelectionReactsOnInterface', 'Drupal\dynamic_reference_selection\Annotation\DynamicReferenceSelectionReactsOn');

    $this->alterInfo('dynamic_reference_selection_reacts_on_info');
    $this->setCacheBackend($cache_backend, 'dynamic_reference_selection_reacts_on_plugins');
  }

}
