<?php

namespace Drupal\dynamic_reference_selection\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * Ajax command to update form options.
 *
 * @package Drupal\dynamic_reference_selection\Ajax
 */
class UpdateOptionsCommand implements CommandInterface {

  /**
   * Constructs a new UpdateOptionsCommand object.
   *
   * @param string $elementId
   *   The element html id.
   * @param array $options
   *   The element options [key, value].
   * @param string $formatter
   *   The field formatter.
   * @param bool $multiple
   *   The 'multiple' attribute of select.
   */
  public function __construct(
    protected $elementId,
    protected array $options,
    protected $formatter,
    protected bool $multiple,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'updateOptionsCommand',
      'method' => 'html',
      'elementId' => $this->elementId,
      'options' => $this->options,
      'formatter' => $this->formatter,
      'multiple' => $this->multiple,
    ];
  }

}
