<?php

namespace Drupal\dynamic_reference_selection\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a dynamic reference selection reacts on item annotation object.
 *
 * @see \Drupal\dynamic_reference_selection\Plugin\DynamicReferenceSelectionReactsOnManager
 * @see plugin_api
 *
 * @Annotation
 */
class DynamicReferenceSelectionReactsOn extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The label of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A human readable description of the Reacts On Event.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The event name that will trigger the rule.
   *
   * @var string
   */
  public $eventName;

  /**
   * The group of the action to be organized in the list box.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $group;

  /**
   * The priority of the event. Bigger is evaluated first.
   *
   * @var int
   */
  public $priority;

  /**
   * If the event need a target entity.
   *
   * @var bool
   */
  public $hasTargetEntity;

  /**
   * If the event has target bundle.
   *
   * @var bool
   */
  public $hasTargetBundle;

}
