<?php

namespace Drupal\dynamic_reference_selection\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines an interface for dynamic reference selection reacts on plugins.
 */
interface DynamicReferenceSelectionReactsOnInterface extends PluginInspectionInterface {

  /**
   * Process the DynamicReferenceSelection form for reactsOn plugins.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state object.
   */
  public function processForm(array &$form, FormStateInterface $form_state);

}
