<?php

namespace Drupal\dynamic_selection_tools\Plugin\Field\FieldWidget;

use Drupal\Core\Form\FormStateInterface;
use Drupal\dynamic_selection_tools\Plugin\Field\DynamicOptionsWidget;

/**
 * Plugin implementation of the 'fixed_options' widget.
 *
 * @FieldWidget(
 *   id = "fixed_options",
 *   module = "dynamic_selection_tools",
 *   label = @Translation("Fixed options"),
 *   field_types = {
 *     "string",
 *     "integer",
 *     "float",
 *     "decimal"
 *   }
 * )
 */
class FixedOptionsWidget extends DynamicOptionsWidget {

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $element = parent::settingsForm($form, $form_state);
    $element['common']['options']['#description'] = $this->t('Enter all your desired options by using the format <strong>value|Label;</strong> (one per line).');

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function provideOptions(array &$form, FormStateInterface $form_state) : array {
    $items = [];
    $settings = $this->getSettings();
    $entity = $form_state->getFormObject()->getEntity();
    $options = $this->replaceTokens($settings['common']['options'], [$entity->getEntityTypeId() => $entity]);
    $options = explode(';', $options);
    if (count($options) > 0) {
      foreach ($options as $option) {
        $fragments = explode('|', $option);
        $value = isset($fragments[0]) ? trim($fragments[0]) : NULL;
        $label = isset($fragments[1]) ? trim($fragments[1]) : NULL;
        if (!is_null($value) && !is_null($label)) {
          $items[(string) $value] = $label;
        }
      }
    }

    return $items;
  }

}
