<?php

namespace Drupal\dynamic_selection_tools\Service;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * The Text pad features interface.
 */
interface TextPadInterface {

  /**
   * Pad an entity field value.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to fetch field value from.
   * @param string $field_name
   *   The field name to get from the passed entity.
   * @param int $delta
   *   The field value's delta.
   * @param string $field_property
   *   The field's property to get. For example "value", "target_id" and so on.
   * @param string $character
   *   The character to use for padding.
   * @param int $amount
   *   The amount of characters to use for padding.
   * @param string $direction
   *   One of "left", "right", "both" to place the padding.
   */
  public function padEntityFieldValue(ContentEntityInterface $entity, string $field_name, int $delta, string $field_property, string $character, int $amount, string $direction = 'left');

  /**
   * Pad a single text.
   *
   * @param string $text
   *   The text to be padded.
   * @param string $character
   *   The character to use for padding.
   * @param int $amount
   *   The amount of characters to use for padding.
   * @param string $direction
   *   One of "left", "right", "both" to place the padding.
   */
  public function padText(string $text, string $character, int $amount, string $direction);

}
