#!/bin/bash

# EAF Module Test Runner Script
# Usage: ./run-tests.sh [unit|kernel|functional|all] [--coverage]

set -e

# Colors for output
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# Get test suite argument (default to all)
SUITE="${1:-all}"
COVERAGE="${2}"

# PHPUnit binary
PHPUNIT="/var/www/html/vendor/bin/phpunit"
BOOTSTRAP="/var/www/html/web/core/tests/bootstrap.php"
MODULE_PATH="/var/www/html/web/modules/mycontrib/eaf"

echo -e "${BLUE}=== EAF Module Test Runner ===${NC}"
echo -e "Test suite: ${GREEN}${SUITE}${NC}"
echo ""

# Base PHPUnit command
BASE_CMD="${PHPUNIT} --bootstrap ${BOOTSTRAP}"

# Add coverage if requested
if [[ "${COVERAGE}" == "--coverage" ]]; then
  echo -e "${BLUE}Coverage reporting enabled${NC}"
  BASE_CMD="${BASE_CMD} --coverage-html ${MODULE_PATH}/coverage"
fi

# Run tests based on suite selection
case "${SUITE}" in
  unit)
    echo -e "${BLUE}Running Unit Tests...${NC}"
    ${BASE_CMD} ${MODULE_PATH}/tests/src/Unit
    ;;
  kernel)
    echo -e "${BLUE}Running Kernel Tests...${NC}"
    ${BASE_CMD} ${MODULE_PATH}/tests/src/Kernel
    ;;
  functional)
    echo -e "${BLUE}Running Functional Tests...${NC}"
    ${BASE_CMD} ${MODULE_PATH}/tests/src/Functional
    ;;
  all)
    echo -e "${BLUE}Running All Tests...${NC}"
    ${BASE_CMD} ${MODULE_PATH}/tests/src/Unit
    echo ""
    echo -e "${BLUE}Kernel tests (when implemented)...${NC}"
    # ${BASE_CMD} ${MODULE_PATH}/tests/src/Kernel
    echo ""
    echo -e "${BLUE}Functional tests (when implemented)...${NC}"
    # ${BASE_CMD} ${MODULE_PATH}/tests/src/Functional
    ;;
  *)
    echo -e "${RED}Invalid test suite: ${SUITE}${NC}"
    echo "Usage: $0 [unit|kernel|functional|all] [--coverage]"
    exit 1
    ;;
esac

echo ""
echo -e "${GREEN}✓ Tests completed${NC}"
