<?php

namespace Drupal\eaf\Plugin\EntityAttribute;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eaf\Attribute\EntityAttribute;
use Drupal\eaf\EntityAttributePluginBase;

/**
 * Plugin implementation of the 'full-width' modifier setting.
 */
#[EntityAttribute(
  id: "full_width",
  label: new TranslatableMarkup("Full width"),
  settings: [
    "parent" => "entity_class",
    "weight" => 10,
  ]
)]
class FullWidth extends EntityAttributePluginBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(): array {
    $element = parent::formElement();

    return [
      '#type' => 'checkbox',
      '#description' => $this->t('Stretch this paragraph to 100% browser width.'),
    ] + $element;
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultValue(): mixed {
    return 0;
  }

  /**
   * {@inheritdoc}
   */
  public function setValue($value, $attributes, $section = NULL): array {
    $attributes = parent::setValue($value, $attributes, $section);
    $attributes['classes'] = [];
    if ($value) {
      $attributes['classes'] = ['full-width'];
    }
    $attributes = parent::setValue($value, $attributes, $section);
    return $attributes;
  }

}
