<?php

namespace Drupal\eaf\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'attributes pretty formatter' formatter.
 *
 * It displays the attributes JSON as a nicely formatted HTML.
 */
#[FieldFormatter(
  id: 'field_attributes_pretty_formatter',
  label: new TranslatableMarkup('Attributes pretty formatter'),
  field_types: [
    'field_attributes_storage'
  ]
)]
class AttributesPrettyFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = [
        '#type' => 'html_tag',
        '#tag' => 'pre',
        '#value' => json_encode(json_decode((string) $item->value), JSON_PRETTY_PRINT),
      ];
    }

    return $elements;
  }

}
