<?php

declare(strict_types=1);

namespace Drupal\eaf\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Defines an EntityAttribute attribute.
 *
 * Plugin developers can use this attribute to define metadata on their
 * plugin classes.
 *
 * Plugin Namespace: Plugin\EntityAttribute
 *
 * @see plugin_api
 * @package Drupal\eaf\Attribute
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class EntityAttribute extends Plugin {

  /**
   * Constructs a new EntityAttribute attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $label
   *   The human-readable name of the setting.
   * @param array $settings
   *   Default settings.
   */
  public function __construct(
    public readonly string $id,
    public readonly mixed $label,
    public readonly array $settings = [],
  ) {}

}
