<?php

namespace Drupal\eaf;

/**
 * Provides interface for entity attributes plugin manager.
 *
 * @package Drupal\eaf
 */
interface EntityAttributePluginManagerInterface {

  const SETTINGS_FORM_STORAGE_CID = 'entity_attribute_plugins:settings_form';

  /**
   * Getter for all plugin instances.
   *
   * @return array
   *   Plugin instances.
   */
  public function getAll(): array;

  /**
   * Gets plugin instance by id.
   *
   * This is a simple wrapper for createInstance method.
   * It is possible that we will load plugin configuration
   * automatically by bundle in some future version.
   * In that case we don't want to use the createInstance method
   * directly.
   *
   * @param string $plugin_id
   *   Plugin id.
   *
   * @return object|\Drupal\eaf\EntityAttributePluginInterface
   *   Instance of entity attribute plugin.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function getPluginById(string $plugin_id);

  /**
   * Getter for settings form built from all plugin instances.
   *
   * @return array
   *   Form elements.
   */
  public function getSettingsFieldForm(): array;

  /**
   * Getter for settings form options from all plugin instances.
   *
   * @return array
   *   An array containing all plugin names and its sub-plugins, keyed by id.
   */
  public function getAttributeFormElements(): array;

}
