<?php

namespace Drupal\eaf;

/**
 * Provides interface for entity attribute field item list.
 *
 * @package Drupal\eaf\Plugin\Field
 */
interface EntityAttributesFieldItemListInterface {

  const CSS_CLASS_DELIMITER = ' ';

  /**
   * Returns given setting value if available.
   *
   * @param string $setting_name
   *   Setting name.
   * @param mixed|null $default
   *   Default value to be used.
   *
   * @return mixed|null
   *   Setting value or default if not found or empty.
   */
  public function getSettingValue(string $setting_name, $default = NULL);

  /**
   * Setter for setting value.
   *
   * @param string $name
   *   Setting name.
   * @param mixed $value
   *   Setting value.
   *
   * @return $this
   */
  public function setSettingValue(string $name, $value): self;

  /**
   * Returns given attribute value.
   *
   * @param string|null $target_section
   *   The section.
   *
   * @return array
   *   The attribute value for the given section.
   */
  public function getEntityAttributeValue(?string $target_section = NULL): array;

}
